<?php
    
    ini_set("display_errors", true);
    error_reporting(E_ALL & ~E_NOTICE & ~E_DEPRECATED);

    function magictoolboxGetThumb($img, $s, $thumbDepends, $imagickpath) {
        $img = str_replace(DIR_WS_IMAGES, '', $img);
        
        if(!file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $img)) return DIR_WS_IMAGES . $img;
        
        $info = pathinfo($img);
        if(intval(phpversion()) < 5 || !isset($info["filename"])) {
            $info["filename"] = basename($info["basename"], ".".$info["extension"]);
        }
        
        if($info['dirname'] == '.') $info['dirname'] = '';
        if(!empty($info['dirname'])) $info['dirname'] .= '/';
        $thumb = 'magicthumbs/' . $info['dirname'] . $info['filename'] . '_' . $s . '.' . $info['extension'];

        if(file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $thumb)) {
            $img_full = DIR_FS_CATALOG . DIR_WS_IMAGES . $img;
            $thumb_full = DIR_FS_CATALOG . DIR_WS_IMAGES . $thumb;
            $time_diff = filemtime($img_full) - filemtime($thumb_full);
        }

        if(!$time_diff || $time_diff != 0) {//create thumb only if it doesn't exists or it is out of date
            $dirs = pathinfo($thumb);
            $dirs = explode("/", $dirs['dirname']);
            $cur = '';
            foreach($dirs as $dir) {
                if(!is_dir(DIR_FS_CATALOG . DIR_WS_IMAGES . $cur . $dir)) mkdir(DIR_FS_CATALOG . DIR_WS_IMAGES . $cur . $dir);
                $cur .= $dir . '/';
            }
            require_once(dirname(__FILE__) . '/magictoolbox.makethumb.class.php');
            new MagicToolboxMakeThumb(DIR_FS_CATALOG . DIR_WS_IMAGES . $img, $s, $s, DIR_FS_CATALOG . DIR_WS_IMAGES . $thumb, $thumbDepends, $imagickpath);
            unset($time_diff);
            clearstatcache();
            if(!file_exists(DIR_FS_CATALOG . DIR_WS_IMAGES . $thumb)) $thumb = $img;
        }
        
        return DIR_WS_IMAGES . $thumb;
    }
    
    function magictoolboxLoadModule($name) {
        if(!isset($GLOBALS["magictoolbox"])) $GLOBALS["magictoolbox"] = array();
        if(!isset($GLOBALS["magictoolbox"][$name])) {
            /* load module */
            require_once(dirname(__FILE__) . '/' . strtolower($name) . '.module.core.class.php');
            $className = $name . 'ModuleCoreClass';
            $mod = new $className;
            /* load params */
            $allParamsLoaded = true;
            foreach($mod->params->getArray() as $id => $param) {
                $value = @constant('ZEN_' . strtoupper($name) . '_' . strtoupper($id));
                if($value !== NULL) $mod->params->set($id, $value);
                else $allParamsLoaded = false;
            }
            if($allParamsLoaded) $GLOBALS["magictoolbox"][$name] = & $mod;
        }
        return isset($mod) ? $mod : $GLOBALS["magictoolbox"][$name];
    }

?>
